<?php

namespace App\Http\Controllers\Admin;

use App\Models\Category;
use App\Models\Media;
use App\Models\Page;
use App\Models\Blog;
use App\Models\Tag;
use App\Models\People;
use App\Models\Contact;
use App\Models\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index(){

        $tags=Tag::all();        
        $categories=Category::all();
         $pages=Page::all();
         $blogs=Blog::all();
         $medias=Media::all();
       
        return view('admin.index',compact('tags','categories','medias','blogs','pages'));
    }

      public function show()
    {  
        return view('admin.profile.index')->with('user',auth()->user());
       
        //
    }
    public function changeprofile()
    {  
     return view('admin.profile.edit')->with('user',auth()->user());
       
        //
    }

      public function updateprofile(Request $request,User $user)
       {

          $this->validate(request(),[
           "name"=> "required|min:2|unique:users,name,".$user->id,
            "email"=> "required|min:7|unique:users,email,".$user->id,
          ]); 

        $user->name=$request->name;
        $user->email=$request->email;
        $user->save();
        session()->flash('success','User information updated sucesfully updated');
        return redirect()->back();
        
      
     

        //
    }

    //
}
